#ifndef __CException__
#define __CException__

//	===========================================================================

#include "../Basics/CString.hpp"
#include <exception>

//	===========================================================================

using Exponent::Basics::CString;
using namespace std;

//	===========================================================================

namespace Exponent
{
	namespace Exceptions
	{
		/**
		 * @class CException CException.hpp
		 * @brief Generic Exception class
		 *
		 * @date 02/10/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.1.0 Added exponent class system
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CException.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CException : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param errorReason The reason for the error
			 * @param functionName The name of the function that generated the error
			 * @param isSerious Is this a serious (app ending) exception
			 */
			CException(const CString &errorReason, const CString &functionName, const bool isSerious = true);

			/**
			 * Destruction
			 */
			virtual ~CException();

//	===========================================================================

			/**
			 * Get the reson for the error
			 * @retval const CString& The reason for the error
			 */
			virtual const CString &getErrorReason() const;

			/**
			 * Get the function name
			 * @retval const CString& The name of the function that threw the error
			 */
			virtual const CString &getFunctionName() const;

			/**
			 * Is the error serious
			 * @retval bool True if the error is serious, false otherwise
			 */
			virtual bool errorIsSerious() const;

//	===========================================================================

		protected:

//	===========================================================================

			CString m_errorReason;				/**< The message associated witht he exception - as description */
			CString m_functionName;				/**< Name of the function that generated the exception */
			bool m_isSerious;					/**< Is the fault serious - does it require an exit essentially */
		};
	}
}
#endif	// End of CException.hpp